uniform int nbWaves;
uniform sampler2D waves;
uniform sampler2D colors;
uniform sampler2D loops;
uniform sampler2D mask;
uniform float fade;
uniform bool hasMask;
uniform int upsideDown[8];

void main()
{
	vec2 uv = gl_TexCoord[0].st;

	float a = smoothstep(0.0, fade, min(uv.x, 1.0-uv.x));
	vec4 color = vec4(0.0,0.0,0.0,0.0);

	for (int i=0; i<8; i++)
	{
		float idx = float(2*i+1) / float(2*nbWaves);
		float h = texture2D(waves, vec2(uv.x, idx)).x;
		vec4 c = texture2D(colors, vec2(idx,0.5));
		c.a *= a;
		if ((upsideDown[i]<0 && uv.y < h) || (upsideDown[i]>0 && (1.0-uv.y < h)))
			color = max(color, c);

		vec4 loop = texture2D(loops, vec2(idx,0.5));
		float loopIn = loop.r + loop.a/256.0;
		float loopOut = loop.g + loop.b/256.0;
		float ca = step(loopIn, uv.x)*step(uv.x, loopOut);
		c.rgb *= (1.0-uv.y);
		color = max(color, c*ca);
	}
	if (hasMask)
		color.a *= texture2D(mask, uv).a;

	gl_FragColor = color;
}
